// Autor: Ante Derek

#include <cstdio>
#include <vector>
#include <string>

using namespace std;

string to_bin(int x) {
  string r = "00000000";
  for (int i=0; i<8; i++) {
    r[7-i] = char(x%2+'0');
    x /= 2;
  }
  return r;
}

int main() {
  int n;
  vector<string> address;
  vector<int> prefix;
  scanf("%d", &n);
  address.resize(n);
  prefix.resize(n);
  for (int i=0; i<n; i++) {
    int a1, a2, a3, a4;
    scanf("%d.%d.%d.%d/%d", &a1, &a2, &a3, &a4, &prefix[i]);
    address[i] = to_bin(a1)+to_bin(a2)+to_bin(a3)+to_bin(a4);
  }
  int a1, a2, a3, a4;
  scanf("%d.%d.%d.%d", &a1, &a2, &a3, &a4);
  string t = to_bin(a1)+to_bin(a2)+to_bin(a3)+to_bin(a4);
  string r;
  for (int i=0; i<n; i++) 
    if (address[i].substr(0, prefix[i]) == t.substr(0, prefix[i]))
      r += "1";
    else
      r += "0";
  printf("%s\n", r.c_str());

  vector<int> inside(n, 1);
  int done = 0;
  while (!done) {
    done = 1;
    for (int i=0; i<n; i++) 
      for (int j=0; j<n; j++)         
        if (inside[i] && inside[j] && i != j) {
          if (address[i] == address[j] && prefix[i] == prefix[j])
            inside[j] = 0, done = 0;
          else if (prefix[i] == prefix[j] && prefix[i] > 0) {
            int l = prefix[i];
            if (address[i].substr(0, l-1) == address[j].substr(0, l-1)) {
              inside[j] = 0;
              done = 0;
              prefix[i]--;
              address[i][prefix[i]] = '0';
              
            }
          }
          else if (prefix[i] < prefix[j]) {
            int l = prefix[i];
            if (address[i].substr(0, l) == address[j].substr(0, l))
              inside[j] = 0;
          }
        }
  }
  int sol = 0;
  for (int i=0; i<n; i++) 
    sol += inside[i];
  printf("%d\n", sol);
  return 0;
}
